﻿/////////////////////////////////////////////////
//　テキスト属性ペースト ver1.0
//　http://sysys.blog.shinobi.jp/Entry/44/
/////////////////////////////////////////////////
var textPropList=[
    {koumoku:'フォント',propNames:['appliedFont','fontStyle']},
    {koumoku:'文字サイズ・行送り',propNames:['pointSize','leading']},
    {koumoku:'垂直・水平比率',propNames:['horizontalScale','verticalScale']},
    {koumoku:'その他基本文字形式',propNames:['underline','strikeThru','kerningMethod','tracking','capitalization','position','ligatures','noBreak','characterAlignment']},
    {koumoku:'その他詳細文字形式',propNames:['baselineShift','skew','tsume','leadingAki','trailingAki','characterRotation','jidori','scaleAffectsLineHeight','cjkGridTracking']},
    {koumoku:'文字カラー',propNames:['fillTint','overprintFill','fillColor','strokeColor','gradientFillLength','gradientFillAngle','gradientFillStart']},
    {koumoku:'線幅・線カラー',propNames:['strokeTint','strokeWeight','overprintStroke','gradientStrokeLength','gradientStrokeAngle','gradientStrokeStart','miterLimit','strokeAlignment','endJoin']},
    {koumoku:'組版設定',propNames:['composer','kinsokuSet','kinsokuType','kinsokuHangType','bunriKinshi','mojikumi','rensuuji','rotateSingleByteCharacters','leadingModel']},
    {koumoku:'段落揃え・インデント・段落前後のアキ',propNames:['justification','balanceRaggedLines','firstLineIndent','leftIndent','rightIndent','spaceBefore','spaceAfter','lastLineIndent']},
    {koumoku:'グリッド揃え・行取り・自動行送り',propNames:['gridAlignFirstLineOnly','gridAlignment','gridGyoudori','paragraphGyoudori','autoLeading']},
    {koumoku:'ジャスティフィケーション・ハイフネーション',propNames:['singleWordJustification','minimumWordSpacing','maximumWordSpacing','desiredWordSpacing','minimumLetterSpacing','maximumLetterSpacing','desiredLetterSpacing','minimumGlyphScaling','maximumGlyphScaling','desiredGlyphScaling','hyphenateCapitalizedWords','hyphenation','hyphenateBeforeLast','hyphenateAfterFirst','hyphenateWordsLongerThan','hyphenateLadderLimit','hyphenationZone','hyphenWeight','hyphenateLastWord','hyphenateAcrossColumns']},
    {koumoku:'ドロップキャップ',propNames:['dropCapLines','dropCapCharacters','dropCapStyle','dropcapDetail']},
    {koumoku:'段落分離禁止・段落の開始位置',propNames:['keepLinesTogether','keepAllLinesTogether','keepWithNext','keepFirstLines','keepLastLines','startParagraph']},
    {koumoku:'段抜き・段分割',propNames:['spanSplitColumnCount','spanColumnType','splitColumnInsideGutter','splitColumnOutsideGutter','spanColumnMinSpaceBefore','spanColumnMinSpaceAfter']},
    {koumoku:'段落境界線',propNames:['ruleAbove','ruleAboveOverprint','ruleAboveLineWeight','ruleAboveTint','ruleAboveOffset','ruleAboveLeftIndent','ruleAboveRightIndent','ruleAboveWidth','ruleAboveColor','ruleAboveGapColor','ruleAboveGapTint','ruleAboveGapOverprint','ruleAboveType','ruleBelow','ruleBelowLineWeight','ruleBelowTint','ruleBelowOffset','ruleBelowLeftIndent','ruleBelowRightIndent','ruleBelowWidth','ruleBelowColor','ruleBelowGapColor','ruleBelowGapTint','ruleBelowType','ruleBelowOverprint','ruleBelowGapOverprint','keepRuleAboveInFrame']},
    {koumoku:'タブ',propNames:['tabList']},
    {koumoku:'下線・打ち消し線設定',propNames:['underlineColor','underlineGapColor','underlineTint','underlineGapTint','underlineOverprint','underlineGapOverprint','underlineType','underlineOffset','underlineWeight','strikeThroughColor','strikeThroughGapColor','strikeThroughTint','strikeThroughGapTint','strikeThroughOverprint','strikeThroughGapOverprint','strikeThroughType','strikeThroughOffset','strikeThroughWeight']},
    {koumoku:'縦中横',propNames:['tatechuyoko','tatechuyokoXOffset','tatechuyokoYOffset']},
    {koumoku:'自動縦中横',propNames:['autoTcy','autoTcyIncludeRoman']},
    {koumoku:'ルビ設定',propNames:['rubyFill','rubyStroke','rubyTint','rubyWeight','rubyOverprintFill','rubyOverprintStroke','rubyStrokeTint','rubyFont','rubyFontStyle','rubyFontSize','rubyOpenTypePro','rubyXScale','rubyYScale','rubyType','rubyAlignment','rubyPosition','rubyXOffset','rubyYOffset','rubyParentSpacing','rubyAutoAlign','rubyOverhang','rubyAutoScaling','rubyParentScalingPercent','rubyParentOverhangAmount','rubyAutoTcyDigits','rubyAutoTcyIncludeRoman','rubyAutoTcyAutoScale']},
    {koumoku:'圏点設定',propNames:['kentenFillColor','kentenStrokeColor','kentenTint','kentenStrokeTint','kentenWeight','kentenOverprintFill','kentenOverprintStroke','kentenKind','kentenPlacement','kentenAlignment','kentenPosition','kentenFont','kentenFontStyle','kentenFontSize','kentenXScale','kentenYScale','kentenCustomCharacter','kentenCharacterSet']},
    {koumoku:'割注設定',propNames:['warichu','warichuSize','warichuLines','warichuLineSpacing','warichuAlignment','warichuCharsAfterBreak','warichuCharsBeforeBreak']},
    {koumoku:'斜体',propNames:['shataiMagnification','shataiDegreeAngle','shataiAdjustRotation','shataiAdjustTsume']},
    {koumoku:'OTF機能',propNames:['otfFigureStyle','otfOrdinal','otfFraction','otfDiscretionaryLigature','otfTitling','otfContextualAlternate','otfSwash','otfSlashedZero','otfHistorical','otfStylisticSets','otfMark','otfLocale','otfOverlapSwash','otfStylisticAlternate','otfJustificationAlternate','otfStretchedAlternate','otfProportionalMetrics','otfHVKana','otfRomanItalics']},
    {koumoku:'適用されている文字スタイル',propNames:['appliedCharacterStyle']},
    {koumoku:'適用されている段落スタイル',propNames:['appliedParagraphStyle']}
];
if (app.scriptPreferences.version>=7) {
    app.doScript(main,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
} else {
    main();
}
function main(){
    var sel0=app.activeDocument.selection[0];
    if (!sel0.hasOwnProperty("appliedParagraphStyle")) return;
    var tempTF=app.activeDocument.textFrames.add();
    var myDiag=app.dialogs.add({name:"テキスト属性をペースト"});
    try {
        var tempStory=tempTF.parentStory;
        tempStory.insertionPoints[0].select();
        app.paste();
        if (tempStory.characters.length==0) throw "";
        var myTextProp=tempStory.characters[0].properties;
        with (myDiag.dialogColumns.add()) {
            for (var i=0;i<textPropList.length;i++){
                checkboxControls.add({staticLabel:textPropList[i].koumoku,checkedState:false});
            }
        }
        if (!myDiag.show()) throw "";
        var props={};
        var checkList=myDiag.dialogColumns[0].checkboxControls.everyItem().checkedState;
        for (var i=0;i<checkList.length;i++){
            if (checkList[i]) {
                for (var j=0;j<textPropList[i].propNames.length;j++){
                    props[textPropList[i].propNames[j]]=myTextProp[textPropList[i].propNames[j]];
                }
            }
        }
        //$.writeln(props.toSource());
        sel0.properties=props;
    } catch (e){
        if (e!="") alert(e);
    } finally {
        myDiag.destroy();
        tempTF.remove();
        sel0.select();
    }
}
